uniform mat4 uniform_mtx4_wvp;
uniform vec3 uniform_vec3_lightdir;
uniform vec3 uniform_vec3_depth;

attribute vec3 attrib_position;
attribute vec3 attrib_normal;
attribute vec4 attrib_rect;
//attribute vec4 attrib_offset;

varying vec4 v_colour;
varying vec3 v_normal;

void main()
{    
    vec2 o = vec2(attrib_rect.z/2.0,-(attrib_rect.w/2.0));
    vec2 c = (attrib_rect.xy + (attrib_rect.zw/2.0))-(o);
    //c += attrib_offset.xy;
    
    vec2 pos = attrib_position.xy*attrib_rect.zw;
    pos += c;    
    
    vec3 lightdir = normalize(uniform_vec3_lightdir);
        
    if ( dot(lightdir,attrib_normal) > 0.0 )
    {
        pos.xy -= (lightdir*65535.0).xy;
    }

    gl_Position = uniform_mtx4_wvp * vec4(pos.xy,uniform_vec3_depth.x,1.0);
	v_normal    = attrib_normal;
}
